//**************************************************************************************
//**************************************************************************************
//****																				****
//****						  		MMS.C											****
//****																				****
//****			Magnetmesssystem mit AS5311 (Austriamicrosystems) V0.9				****
//****			Auswertung der Encoderdaten mit 18F1320								****
//****			Ansteuerung ber serielle Schnittstelle								****
//****			copyrigth (c) 2010 by Dipl. Ing. Steffen Taubmann					****
//****																				****
//****			Kontakt: steffenta@gmx.de											****
//****																				****
//**************************************************************************************
//****		 																		****
//****	Fr private Anwender gilt:													****
//****		 																		****
//****		Dieses Programm ist freie Software. Sie knnen es unter den Bedingungen ****
//****		der GNU General Public License, wie von der Free Software Foundation 	****
//****		verffentlicht, weitergeben und/oder modifizieren, entweder gem 		****
//****		Version 3 der Lizenz oder (nach Ihrer Option) jeder spteren Version.	****
//****																				****
//****		Die Verffentlichung dieses Programms erfolgt in der Hoffnung, da es	****
//****		Ihnen von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, sogar ohne	****
//****		die implizite Garantie der MARKTREIFE oder der VERWENDBARKEIT FR EINEN	****
//****		BESTIMMTEN ZWECK. Details finden Sie in der GNU General Public License.	****
//****		 																		****
//****		Sie sollten ein Exemplar der GNU General Public License zusammen mit	****
//****		diesem Programm erhalten haben. 										****
//****		Falls nicht, siehe <http://www.gnu.org/licenses/>.						****
//****																				****
//****	Die kommerzielle Verwendung des Quellcodes bedarf generell der Genehmigung	****
//****	des Autors. Mit kommerzieller Verwendung ist der Verkauf von auf diesem		****
//****	Code basierenden Systemen zu verstehen. Der Einsatz des Systems in einem	****
//****	kommerziellen Umfeld ist davon nicht betroffen.								****
//****																				****
//**************************************************************************************
//**************************************************************************************

#include "18F1320.h"
//#device HIGH_INTS=TRUE
//#device ICD=TRUE
#include "18F1320_FSR.h"
#include "global.h"
#include "RS232.h"
#include "interrupt.h"
#include "functions.h"
#include "AS5311.h"
#include "befehl.h"

#fuses INTRC_IO,NOFCMEN,BROWNOUT,BORV42,WDT128,WDT,NOCPD,STVREN,DEBUG,NOLVP,NOWRT,NOWRTD,NOWRTC,MCLR,NOPROTECT,NOIESO
#use delay(clock=8000000, restart_wdt)
#rom 0xF000FF={0}								// Adresse per Default auf 0x00

void main()
{ short SerDataValid;
  int16 LastValue=0;
  signed int16 Diff;
  
  InitPic();
  Power=1;

  while (True)
  { restart_wdt();

	// Daten vom AS5311 holen?
//	if (_TimeToRead5311)
// Daten stndig, ohne Verzgerungen lesen
// Vmax > 2m/s
	{ LastValue=AS5311Value;					// letzten Messwert abspeichern
	  SerDataValid=Get5311Data(0);				// aktuellen einlesen
	  Diff=AS5311Value-LastValue;				// Differenzbilden
	  if (abs(Diff)>0x800)						// "berlauf"?
	  { If(Diff<0)
		  PosT1+=4096;
		else
		  PosT1-=4096;
	  }
	  Messwert.I32=PosT1+AS5311Value-MWOffset;
	  _TimeToRead5311=false;
	}

	// Reaktion auf empfangene Daten?
	if (_DatenEmpfangen)
	{ DatensatzAuswerten();
	  while(!TRMT); 							// warten bis Sendepuffer leer
	  RS485_TXEN=0;								// Treiber auf Empfang
	}
	DoNop;
  }

}

